%% Multimodal analysis of ALS data
% © Regents of the University of Minnesota.
% This software is licensed under The MIT License.
% How to cite: If you use this software for your work, please cite the following paper: 
%Pisharady, P.K., Eberly, L.E. et al., Improved Diagnostic Accuracy and Sensitivity to Longitudinal Change in ALS with Multimodal MRI of the Brain and Cervical Cord

% Deidentified data will be made available on request for the purposes of reproducing the results presented, subject to institutional approval.
%%
clc
clear all
close all

%% Read data
cd /Users/pramodkp/Works/Projects/ALS
T = readtable('Multimodal_data_cross.xlsx'); %This excel file contains the multimodal data 
X=[T.Var1(1:end-1) T.Var2(1:end-1) T.Var3(1:end-1) T.Var4(1:end-1) T.Var5(1:end-1)]; % The first five columns contains the five multimodal measures (Fsum, FA, cortical thickness, FA at C2-CST, and CSA at C2)
Y=T.Var7(1:end-1); % Disease status, 1-Control, 2- ALS

%% Define which measures are to be used in the multimodal analysis
 X=X(:,1:5); % All the 5 measures are used here
 %X=[X(:,2:2) X(:,3:5)]; % Select the measures you want like this
 X_Y=[X Y];
 
 %% Multivariable logistic regression, cross validation
 for i=1:40 %looping for cross validation
     X_Y_train=X_Y;
     X_Y_train(i,:)=[];
     X_train=X_Y_train(:,1:end-1);
     Y_train=X_Y_train(:,end);
     X_Y_test=X_Y(i,:);
     X_test=X_Y_test(:,1:end-1);
     Y_test=X_Y_test(:,end);
 [B,dev,stats] = mnrfit(X_train,Y_train);
 pihat = mnrval(B,X_test);
 [maxi class]=max(pihat');
 maxi_final(i)=maxi;
 predicted_Y(i)=class;
 end
 
 %% Accuracy, sensitivity, and specificity calculations
 Accuracy=100-(nnz(predicted_Y'-Y)/40)*100
 tp = sum((predicted_Y' == 2) & (Y == 2));
 fp = sum((predicted_Y' == 2) & (Y == 1));
 tn = sum((predicted_Y' == 1) & (Y == 1));
 fn = sum((predicted_Y' == 1) & (Y == 2));
 sensitivity = tp/(tp + fn)  %TPR
 specificity = tn/(tn + fp)  %TNR